GPU Workshop Sample Code      {#mainpage}
========================

This package contains sample code for use in the GPU workshop.
The code is described in more detail in the accompanying slides.

#### DevQuery
devQuery/devQuery.cu

This sample queries the properties of the CUDA devices present in the system. 


#### VecAdd
vecAdd/vecAdd.cu

A simple example of a kernel to add two vectors elementwise


#### SimpleMath
simpleMath/simpleMath.cu

The example demonstrates several kernels that do simple math operations


#### MappedMemory
mappedMemory/mappedMemory.cu

This sample demonstrates the use of mapped variables.


#### DeviceQualifier
deviceQualifier/deviceQualifier.cu

This sample demonstrates the `__device__` qualifier.


#### Reduce1
reduce1/reduce1.cu

Compute blockwise sums of a vector x of length n.


#### Reduce2
reduce2/reduce2.cu

Compute column sums of a M x N array.  Each column
is reduced by a single thread block.


#### Reduce3
reduce3/reduce3.cu

Compute column sums of a M x N array.  Each column
is reduced by several thread blocks.


#### SimpleRandom
simpleRandom/simpleRandom.cu


#### SimpleMatlab


#### OptionPricing


#### SimpleThrust
simpleThrust/simpleThrust.cu


#### SimpleArrayfire
simpleArrayfire/simplearrayfire.cu


#### Mycuda
Utilities and macros

* include/mycuda.h
* include/mycuda_reduce.h
* include/mycuda_scan.h
* include/mycuda_random.h

















