.PHONY : all clean run

CUDA      = /usr/local/cuda
NVCCFLAGS = -gencode arch=compute_20,code=compute_20 --ptxas-options=-v \
            -m64 --compiler-options -fno-strict-aliasing -DUNIX -O2
LINKFLAGS = -fPIC -m64
INC       = -I. -I ../include -I${CUDA}/include
LIB       = -L${CUDA}/lib64
LIBS      = -lcudart -lcurand -lm

all :
	nvcc ${NVCCFLAGS} ${INC} -o ${PROJECT}.o -c ${PROJECT}.cu  
	g++  ${LINKFLAGS} -o ${PROJECT} ${PROJECT}.o ${LIB} ${LIBS}   

run : all
	./${PROJECT}

clean :
	rm -f *.o *.ptx

 
#vim:ft=make
