function price = black_scholes_price( S, K, T, r, sigma, flag)
% price = black_scholes_price( S, K, T, r, sigma, flag)
%    flag:  CALL = 0
%           PUT  = 1

    CALL = 0;
    PUT  = 1;

    d1 = ( log( S ./ K ) + (r + 0.5 .* sigma .^ 2) .* T ) / ( sigma .* sqrt(T) );
    d2 = d1 - sigma .* sqrt(T);

    switch flag
        case CALL     
            price = S .* normcdf(d1) - K .* exp(-r .* T) .* normcdf(d2);
        case PUT
            price = K .* exp( -r.*T ) .* normcdf(-d2) - S .* normcdf(-d1);
        otherwise
            error( 'Bad value for flag' )
    end
end    
