/// \file myfun.cu
/// \brief Simple CUDA kernel for demonstrating Matlab GPU capabilities


__global__ void
myfun( float * z, const float * x, const float * y, int n, int m ) {
    int tid = blockIdx.x*blockDim.x+threadIdx.x;
    int nthreads = blockDim.x*gridDim.x;

    for (int i=tid; i<n; i+=nthreads) {
        z[i] = x[i] + y[i];
    }
}




