% Simple matlab script demonstrating a few GPU functions

clear all

gpuDevice()   % Show GPU properties
n = 1024;
m = 64;


x = gpuArray.ones( n, m, 'single' );    % create GPUarray
y = gpuArray.rand( n, m, 'single' );
z1 = x' * y;       % Matrix multiplication
z2 = x+y;        
z3 = exp(y);

z3_h = gather( z3 );   % Copy to host 


my_kernel = parallel.gpu.CUDAKernel('myfun.ptx', 'myfun.cu');
my_kernel.ThreadBlockSize = 256;
my_kernel.GridSize        = 256;
my_kernel                          % display kernel attributes

z = gpuArray.zeros( n, m, 'single' );
z = feval( my_kernel, z, x, y, n, m ); 

whos           % show workspace variables


