/** \file simpleThrust.cu
 *  \brief Demonsrates Thrust library
 *
 *    #### Notes
 *     * Adapted from Thrust documentation.
 *     * Modified by Garland Durham, 7-1-2013
 */

#include <thrust/device_vector.h>
#include <thrust/transform.h>
#include <thrust/sequence.h>
#include <thrust/copy.h>
#include <thrust/fill.h>
#include <thrust/replace.h>
#include <thrust/functional.h>
#include <thrust/reduce.h>
#include <iostream>
#include <stdio.h>



int main(void)
{
    const int n = 1024;

    // allocate three device_vectors with 10 elements
    thrust::device_vector<int> X(n);
    thrust::device_vector<int> Y(n);
    thrust::device_vector<int> Z(n);

    // initialize X to 0,1,2,3, ....
    thrust::sequence(X.begin(), X.end());

    // compute Y = -X
    thrust::transform(X.begin(), X.end(), Y.begin(), thrust::negate<int>());

    // fill Z with twos
    thrust::fill(Z.begin(), Z.end(), 2);

    // compute Y = X mod 2
    thrust::transform(X.begin(), X.end(), Z.begin(), Y.begin(), thrust::modulus<int>());

    // replace all the ones in Y with tens
    thrust::replace(Y.begin(), Y.end(), 1, 10);

    // print Y
    thrust::copy(Y.begin(), Y.begin()+20, std::ostream_iterator<int>(std::cout, "\n"));

    // reduction
    thrust::device_vector<float> X2(n);
    thrust::sequence( X2.begin(), X2.end() ); 
    float xsum = thrust::reduce( X2.begin(), X2.end() );
    printf( "sum is %12.1f\n", xsum );
   
    return 0;    
}
